//
//  InterfaceController.swift
//  reloadRootControllers WatchKit Extension
//
//  Created by yoshiyuki oshige on 2015/04/01.
//  Copyright (c) 2015年 yoshiyuki oshige. All rights reserved.
//

import WatchKit
import Foundation


class InterfaceController: WKInterfaceController {

    // 2pagesボタンとOutlet接続する
    @IBAction func tap2pages() {
        // ２ページ作る
        WKInterfaceController.reloadRootControllersWithNames(["bluePage", "yellowPage"], contexts:["page1", "page2"])
    }
    
    // 3pagesボタンとOutlet接続する
    @IBAction func tap3pages() {
        // ３ページ作る
        WKInterfaceController.reloadRootControllersWithNames(["bluePage", "yellowPage", "redPage"], contexts:nil)
    }
    
    override func awakeWithContext(context: AnyObject?) {
        super.awakeWithContext(context)
        
        // 引数のcontextを出力します
        if let msg: AnyObject = context {
            println(msg)
        }
    }
    

    override func willActivate() {
        // This method is called when watch view controller is about to be visible to user
        super.willActivate()
    }

    override func didDeactivate() {
        // This method is called when watch view controller is no longer visible
        super.didDeactivate()
    }

}
